use tws::Client;
use tokio::io::Error;
use tws::ws::Msg;
use env_logger::Builder;
use log::LevelFilter;
use async_channel::RecvError;
use flate2::read::MultiGzDecoder;
use std::io::Read;

#[tokio::main]
async fn main() -> Result<(), Error> {
    let mut builder = Builder::new();
    builder.filter_level(LevelFilter::Trace);
    builder.init();

    let mut client = Client::new("wss://sfstream.binance.com/stream?streams=btcusdt@trade", true);
    // let client = Client::new("wss://sfstream.binance.com/stream", true);
    // let mut client = Client::new("ws://127.0.0.1:3012/", true);


    let msg = "{\"method\": \"SUBSCRIBE\",\"params\":[\"btcusdt@aggTrade\",\"btcusdt@depth\"],\"id\": 1}";
    let msg2 = "{\"method\": \"SUBSCRIBE\",\"params\":[\"btcusdt@aggTrade\",\"btcusdt@depth\"],\"id\": 2}";


    let vec1 = vec![Msg::Text(msg.to_string().into_bytes()), Msg::Text(msg2.to_string().into_bytes())];
    client.auto_reconnect(vec1, tokio::time::Duration::from_millis(3000));

    // let mut socket = client.connect2().await?;
    let mut socket = client.connect_empty().await?;


    // let _ = socket.send(Msg::Text(msg.to_string().into_bytes())).await;

    // loop {
    //     tokio::time::sleep(tokio::time::Duration::from_millis(300)).await;
    // }

    // let m = socket.recv().await;

    // match m {
    //     Ok(msg) => {
    //
    //     }
    //     Err(err) => {}
    // }

    while let Ok(msg) = socket.recv().await {
        match msg {
            Msg::Text(m) => {
                println!("{}", String::from_utf8(m).unwrap());
            }
            Msg::Binary(m) => {
                // println!("{}", m.len());
                let mut gz = MultiGzDecoder::new(&m[..]);
                let mut s = String::new();
                gz.read_to_string(&mut s).unwrap();
                println!("{}", s);
            }
            Msg::Close(_) => {
                println!("Close");
            }
            Msg::Ping(m) => {
                println!("ping {:?}", m);
                socket.send(Msg::Pong(m));
            }
            Msg::Pong(_) => {}
        }
    }

    Ok(())
}