pub const NUC_QUAD_LOOKUP: [[u8; 4]; 256] = [
    [b'T', b'T', b'T', b'T'],
    [b'T', b'T', b'T', b'C'],
    [b'T', b'T', b'T', b'A'],
    [b'T', b'T', b'T', b'G'],
    [b'T', b'T', b'C', b'T'],
    [b'T', b'T', b'C', b'C'],
    [b'T', b'T', b'C', b'A'],
    [b'T', b'T', b'C', b'G'],
    [b'T', b'T', b'A', b'T'],
    [b'T', b'T', b'A', b'C'],
    [b'T', b'T', b'A', b'A'],
    [b'T', b'T', b'A', b'G'],
    [b'T', b'T', b'G', b'T'],
    [b'T', b'T', b'G', b'C'],
    [b'T', b'T', b'G', b'A'],
    [b'T', b'T', b'G', b'G'],
    [b'T', b'C', b'T', b'T'],
    [b'T', b'C', b'T', b'C'],
    [b'T', b'C', b'T', b'A'],
    [b'T', b'C', b'T', b'G'],
    [b'T', b'C', b'C', b'T'],
    [b'T', b'C', b'C', b'C'],
    [b'T', b'C', b'C', b'A'],
    [b'T', b'C', b'C', b'G'],
    [b'T', b'C', b'A', b'T'],
    [b'T', b'C', b'A', b'C'],
    [b'T', b'C', b'A', b'A'],
    [b'T', b'C', b'A', b'G'],
    [b'T', b'C', b'G', b'T'],
    [b'T', b'C', b'G', b'C'],
    [b'T', b'C', b'G', b'A'],
    [b'T', b'C', b'G', b'G'],
    [b'T', b'A', b'T', b'T'],
    [b'T', b'A', b'T', b'C'],
    [b'T', b'A', b'T', b'A'],
    [b'T', b'A', b'T', b'G'],
    [b'T', b'A', b'C', b'T'],
    [b'T', b'A', b'C', b'C'],
    [b'T', b'A', b'C', b'A'],
    [b'T', b'A', b'C', b'G'],
    [b'T', b'A', b'A', b'T'],
    [b'T', b'A', b'A', b'C'],
    [b'T', b'A', b'A', b'A'],
    [b'T', b'A', b'A', b'G'],
    [b'T', b'A', b'G', b'T'],
    [b'T', b'A', b'G', b'C'],
    [b'T', b'A', b'G', b'A'],
    [b'T', b'A', b'G', b'G'],
    [b'T', b'G', b'T', b'T'],
    [b'T', b'G', b'T', b'C'],
    [b'T', b'G', b'T', b'A'],
    [b'T', b'G', b'T', b'G'],
    [b'T', b'G', b'C', b'T'],
    [b'T', b'G', b'C', b'C'],
    [b'T', b'G', b'C', b'A'],
    [b'T', b'G', b'C', b'G'],
    [b'T', b'G', b'A', b'T'],
    [b'T', b'G', b'A', b'C'],
    [b'T', b'G', b'A', b'A'],
    [b'T', b'G', b'A', b'G'],
    [b'T', b'G', b'G', b'T'],
    [b'T', b'G', b'G', b'C'],
    [b'T', b'G', b'G', b'A'],
    [b'T', b'G', b'G', b'G'],
    [b'C', b'T', b'T', b'T'],
    [b'C', b'T', b'T', b'C'],
    [b'C', b'T', b'T', b'A'],
    [b'C', b'T', b'T', b'G'],
    [b'C', b'T', b'C', b'T'],
    [b'C', b'T', b'C', b'C'],
    [b'C', b'T', b'C', b'A'],
    [b'C', b'T', b'C', b'G'],
    [b'C', b'T', b'A', b'T'],
    [b'C', b'T', b'A', b'C'],
    [b'C', b'T', b'A', b'A'],
    [b'C', b'T', b'A', b'G'],
    [b'C', b'T', b'G', b'T'],
    [b'C', b'T', b'G', b'C'],
    [b'C', b'T', b'G', b'A'],
    [b'C', b'T', b'G', b'G'],
    [b'C', b'C', b'T', b'T'],
    [b'C', b'C', b'T', b'C'],
    [b'C', b'C', b'T', b'A'],
    [b'C', b'C', b'T', b'G'],
    [b'C', b'C', b'C', b'T'],
    [b'C', b'C', b'C', b'C'],
    [b'C', b'C', b'C', b'A'],
    [b'C', b'C', b'C', b'G'],
    [b'C', b'C', b'A', b'T'],
    [b'C', b'C', b'A', b'C'],
    [b'C', b'C', b'A', b'A'],
    [b'C', b'C', b'A', b'G'],
    [b'C', b'C', b'G', b'T'],
    [b'C', b'C', b'G', b'C'],
    [b'C', b'C', b'G', b'A'],
    [b'C', b'C', b'G', b'G'],
    [b'C', b'A', b'T', b'T'],
    [b'C', b'A', b'T', b'C'],
    [b'C', b'A', b'T', b'A'],
    [b'C', b'A', b'T', b'G'],
    [b'C', b'A', b'C', b'T'],
    [b'C', b'A', b'C', b'C'],
    [b'C', b'A', b'C', b'A'],
    [b'C', b'A', b'C', b'G'],
    [b'C', b'A', b'A', b'T'],
    [b'C', b'A', b'A', b'C'],
    [b'C', b'A', b'A', b'A'],
    [b'C', b'A', b'A', b'G'],
    [b'C', b'A', b'G', b'T'],
    [b'C', b'A', b'G', b'C'],
    [b'C', b'A', b'G', b'A'],
    [b'C', b'A', b'G', b'G'],
    [b'C', b'G', b'T', b'T'],
    [b'C', b'G', b'T', b'C'],
    [b'C', b'G', b'T', b'A'],
    [b'C', b'G', b'T', b'G'],
    [b'C', b'G', b'C', b'T'],
    [b'C', b'G', b'C', b'C'],
    [b'C', b'G', b'C', b'A'],
    [b'C', b'G', b'C', b'G'],
    [b'C', b'G', b'A', b'T'],
    [b'C', b'G', b'A', b'C'],
    [b'C', b'G', b'A', b'A'],
    [b'C', b'G', b'A', b'G'],
    [b'C', b'G', b'G', b'T'],
    [b'C', b'G', b'G', b'C'],
    [b'C', b'G', b'G', b'A'],
    [b'C', b'G', b'G', b'G'],
    [b'A', b'T', b'T', b'T'],
    [b'A', b'T', b'T', b'C'],
    [b'A', b'T', b'T', b'A'],
    [b'A', b'T', b'T', b'G'],
    [b'A', b'T', b'C', b'T'],
    [b'A', b'T', b'C', b'C'],
    [b'A', b'T', b'C', b'A'],
    [b'A', b'T', b'C', b'G'],
    [b'A', b'T', b'A', b'T'],
    [b'A', b'T', b'A', b'C'],
    [b'A', b'T', b'A', b'A'],
    [b'A', b'T', b'A', b'G'],
    [b'A', b'T', b'G', b'T'],
    [b'A', b'T', b'G', b'C'],
    [b'A', b'T', b'G', b'A'],
    [b'A', b'T', b'G', b'G'],
    [b'A', b'C', b'T', b'T'],
    [b'A', b'C', b'T', b'C'],
    [b'A', b'C', b'T', b'A'],
    [b'A', b'C', b'T', b'G'],
    [b'A', b'C', b'C', b'T'],
    [b'A', b'C', b'C', b'C'],
    [b'A', b'C', b'C', b'A'],
    [b'A', b'C', b'C', b'G'],
    [b'A', b'C', b'A', b'T'],
    [b'A', b'C', b'A', b'C'],
    [b'A', b'C', b'A', b'A'],
    [b'A', b'C', b'A', b'G'],
    [b'A', b'C', b'G', b'T'],
    [b'A', b'C', b'G', b'C'],
    [b'A', b'C', b'G', b'A'],
    [b'A', b'C', b'G', b'G'],
    [b'A', b'A', b'T', b'T'],
    [b'A', b'A', b'T', b'C'],
    [b'A', b'A', b'T', b'A'],
    [b'A', b'A', b'T', b'G'],
    [b'A', b'A', b'C', b'T'],
    [b'A', b'A', b'C', b'C'],
    [b'A', b'A', b'C', b'A'],
    [b'A', b'A', b'C', b'G'],
    [b'A', b'A', b'A', b'T'],
    [b'A', b'A', b'A', b'C'],
    [b'A', b'A', b'A', b'A'],
    [b'A', b'A', b'A', b'G'],
    [b'A', b'A', b'G', b'T'],
    [b'A', b'A', b'G', b'C'],
    [b'A', b'A', b'G', b'A'],
    [b'A', b'A', b'G', b'G'],
    [b'A', b'G', b'T', b'T'],
    [b'A', b'G', b'T', b'C'],
    [b'A', b'G', b'T', b'A'],
    [b'A', b'G', b'T', b'G'],
    [b'A', b'G', b'C', b'T'],
    [b'A', b'G', b'C', b'C'],
    [b'A', b'G', b'C', b'A'],
    [b'A', b'G', b'C', b'G'],
    [b'A', b'G', b'A', b'T'],
    [b'A', b'G', b'A', b'C'],
    [b'A', b'G', b'A', b'A'],
    [b'A', b'G', b'A', b'G'],
    [b'A', b'G', b'G', b'T'],
    [b'A', b'G', b'G', b'C'],
    [b'A', b'G', b'G', b'A'],
    [b'A', b'G', b'G', b'G'],
    [b'G', b'T', b'T', b'T'],
    [b'G', b'T', b'T', b'C'],
    [b'G', b'T', b'T', b'A'],
    [b'G', b'T', b'T', b'G'],
    [b'G', b'T', b'C', b'T'],
    [b'G', b'T', b'C', b'C'],
    [b'G', b'T', b'C', b'A'],
    [b'G', b'T', b'C', b'G'],
    [b'G', b'T', b'A', b'T'],
    [b'G', b'T', b'A', b'C'],
    [b'G', b'T', b'A', b'A'],
    [b'G', b'T', b'A', b'G'],
    [b'G', b'T', b'G', b'T'],
    [b'G', b'T', b'G', b'C'],
    [b'G', b'T', b'G', b'A'],
    [b'G', b'T', b'G', b'G'],
    [b'G', b'C', b'T', b'T'],
    [b'G', b'C', b'T', b'C'],
    [b'G', b'C', b'T', b'A'],
    [b'G', b'C', b'T', b'G'],
    [b'G', b'C', b'C', b'T'],
    [b'G', b'C', b'C', b'C'],
    [b'G', b'C', b'C', b'A'],
    [b'G', b'C', b'C', b'G'],
    [b'G', b'C', b'A', b'T'],
    [b'G', b'C', b'A', b'C'],
    [b'G', b'C', b'A', b'A'],
    [b'G', b'C', b'A', b'G'],
    [b'G', b'C', b'G', b'T'],
    [b'G', b'C', b'G', b'C'],
    [b'G', b'C', b'G', b'A'],
    [b'G', b'C', b'G', b'G'],
    [b'G', b'A', b'T', b'T'],
    [b'G', b'A', b'T', b'C'],
    [b'G', b'A', b'T', b'A'],
    [b'G', b'A', b'T', b'G'],
    [b'G', b'A', b'C', b'T'],
    [b'G', b'A', b'C', b'C'],
    [b'G', b'A', b'C', b'A'],
    [b'G', b'A', b'C', b'G'],
    [b'G', b'A', b'A', b'T'],
    [b'G', b'A', b'A', b'C'],
    [b'G', b'A', b'A', b'A'],
    [b'G', b'A', b'A', b'G'],
    [b'G', b'A', b'G', b'T'],
    [b'G', b'A', b'G', b'C'],
    [b'G', b'A', b'G', b'A'],
    [b'G', b'A', b'G', b'G'],
    [b'G', b'G', b'T', b'T'],
    [b'G', b'G', b'T', b'C'],
    [b'G', b'G', b'T', b'A'],
    [b'G', b'G', b'T', b'G'],
    [b'G', b'G', b'C', b'T'],
    [b'G', b'G', b'C', b'C'],
    [b'G', b'G', b'C', b'A'],
    [b'G', b'G', b'C', b'G'],
    [b'G', b'G', b'A', b'T'],
    [b'G', b'G', b'A', b'C'],
    [b'G', b'G', b'A', b'A'],
    [b'G', b'G', b'A', b'G'],
    [b'G', b'G', b'G', b'T'],
    [b'G', b'G', b'G', b'C'],
    [b'G', b'G', b'G', b'A'],
    [b'G', b'G', b'G', b'G'],
];

#[cfg(test)]
mod tests {
    use super::NUC_QUAD_LOOKUP;

    #[test]
    fn test_quad_lookup() {
        const NUC: &[u8; 4] = b"TCAG";
        for byte in 0..256_usize {
            let quad = NUC_QUAD_LOOKUP[byte];
            assert_eq!(quad[0], NUC[(byte & 192) >> 6]);
            assert_eq!(quad[1], NUC[(byte & 48) >> 4]);
            assert_eq!(quad[2], NUC[(byte & 12) >> 2]);
            assert_eq!(quad[3], NUC[byte & 3]);
        }
    }
}
