/*
    TILEFLAG_OPAQUE tables for all images that are included in the DDNet client
    excluded are those which have no opaque tiles
*/

pub const DDNET_EXTERNAL_IMAGES: [(&str, [[bool; 16]; 16]); 22] = [
    ("basic_freeze", BASIC_FREEZE),
    ("ddmax_freeze", DDMAX_FREEZE),
    ("ddnet_walls", DDNET_WALLS),
    ("desert_doodads", DESERT_DOODADS),
    ("desert_main", DESERT_MAIN),
    ("desert_sun", DESERT_SUN),
    ("generic_clear", GENERIC_CLEAR),
    ("generic_unhookable", GENERIC_UNHOOKABLE),
    ("generic_unhookable_0.7", GENERIC_UNHOOKABLE_VANILLA),
    ("grass_doodads", GRASS_DOODADS),
    ("grass_doodads_0.7", GRASS_DOODADS_VANILLA),
    ("grass_main", GRASS_MAIN),
    ("grass_main_0.7", GRASS_MAIN_VANILLA),
    ("jungle_doodads", JUNGLE_DOODADS),
    ("jungle_main", JUNGLE_MAIN),
    ("jungle_midground", JUNGLE_MIDGROUND),
    ("mixed_tiles", MIXED_TILES),
    ("moon", MOON),
    ("round_tiles", ROUND_TILES),
    ("sun", SUN),
    ("winter_doodads", WINTER_DOODADS),
    ("winter_main", WINTER_MAIN),
];

const BASIC_FREEZE: [[bool; 16]; 16] =
    [
        [false, false, false, false, true , false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
        [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    ];
const DDMAX_FREEZE: [[bool; 16]; 16] =
[
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DDNET_WALLS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [true , true , true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DESERT_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DESERT_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, true , true , true , false, false, false, false, false, false, false, false],
    [true , false, true , false, true , true , false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , false, true , true , false, false, false, false, false, false, false, false, false],
    [false, true , true , true , true , true , true , true , true , true , false, false, false, false, false, false],
    [true , false, true , false, true , true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , false, false, false, false, false, false],
    [true , true , true , true , true , true , true , true , true , true , false, false, false, false, false, false],
    [true , true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DESERT_SUN: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GENERIC_CLEAR: [[bool; 16]; 16] =
[
    [false, true , true , true , true , true , true , false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GENERIC_UNHOOKABLE: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, true , true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [true , true , true , false, false, false, false, true , true , true , false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, true , false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GENERIC_UNHOOKABLE_VANILLA: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, true , true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [true , true , true , false, true , false, false, true , true , true , false, true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , true , false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, true , false, false, false],
    [false, true , true , false, false, false, false, true , false, false, false, true , true , false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_DOODADS_VANILLA: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , false, false, false, false, false, true , false, false, false, true , false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , true , false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, false, false, false, false, false, false, true , true , true , false, false],
    [true , true , true , true , false, false, false, false, false, false, false, true , true , true , false, false],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , true , false, false],
    [true , true , true , true , false, true , true , false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , false, false, false, true , true , true , false, false, false, false, false],
    [true , true , false, false, false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_MAIN_VANILLA: [[bool; 16]; 16] =
[
    [false, true , true , true , false, false, true , false, false, false, false, true , true , true , true , true ],
    [true , true , true , true , false, false, false, false, false, false, false, true , true , true , true , true ],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , true , true , true ],
    [true , true , true , true , false, true , true , false, false, false, false, false, false, true , true , true ],
    [true , true , true , true , true , true , true , false, true , true , true , false, false, false, false, false],
    [true , true , false, true , false, true , true , false, true , true , true , false, false, false, false, false],
    [false, false, true , true , false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [false, true , false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [true , true , true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const JUNGLE_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, true , true , true , true , true , true , true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, true , true , false, false, true , true , false],
    [false, false, false, false, false, false, false, false, false, true , false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , true , false, false, false, false, true , true , false, false, false, false, false, false],
];
const JUNGLE_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, false, false, false, false, false, false, false, false, true , false, false],
    [true , true , true , true , false, false, false, false, false, false, false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , true , false, false],
    [true , true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , true , true , true , true , true , true , false, false, false, false],
    [true , true , false, false, false, false, false, true , true , true , true , true , false, false, false, false],
    [false, true , true , false, false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, true , false, true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const JUNGLE_MIDGROUND: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , false, false, false, false, false],
    [false, true , true , true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, true , true , true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , false, false, true , false, false, false, false, false, false, false, false, false],
    [false, false, false, true , false, false, true , true , false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , true , true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const MIXED_TILES: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [true , false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const MOON: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const ROUND_TILES: [[bool; 16]; 16] =
[
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const SUN: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const WINTER_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, true , false, false, false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , false, false, false],
];
const WINTER_MAIN: [[bool; 16]; 16] =
[
    [false, true , false, true , true , false, false, false, false, true , true , true , true , true , true , true ],
    [false, true , true , true , false, false, true , true , false, true , true , true , true , true , true , true ],
    [false, true , true , true , true , true , true , true , true , false, true , true , true , true , true , false],
    [false, true , true , true , true , true , true , true , true , false, true , true , false, false, true , false],
    [false, true , true , true , true , true , true , true , true , false, true , false, false, false, true , false],
    [false, false, true , true , true , false, false, false, true , true , true , false, true , true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
