/*
    TILEFLAG_OPAQUE tables for all images that are included in the vanilla teeworlds client
    excluded are those which have no opaque tiles
*/

pub const VANILLA_EXTERNAL_IMAGES: [(&str, [[bool; 16]; 16]); 13] = [
    ("desert_doodads", DESERT_DOODADS),
    ("desert_main", DESERT_MAIN),
    ("desert_sun", DESERT_SUN),
    ("generic_unhookable", GENERIC_UNHOOKABLE),
    ("grass_doodads", GRASS_DOODADS),
    ("grass_main", GRASS_MAIN),
    ("jungle_doodads", JUNGLE_DOODADS),
    ("jungle_main", JUNGLE_MAIN),
    ("jungle_midground", JUNGLE_MIDGROUND),
    ("moon", MOON),
    ("sun", SUN),
    ("winter_doodads", WINTER_DOODADS),
    ("winter_main", WINTER_MAIN),
];


const DESERT_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DESERT_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, true , true , true , false, false, true , true , false, false, true , false],
    [true , false, true , false, true , true , false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , false, true , false, false, false, false, false, false],
    [true , true , true , true , true , true , false, false, false, false, false, false, false, true , false, false],
    [true , true , true , true , false, true , true , false, false, false, false, false, false, true , false, false],
    [false, true , true , true , true , true , true , true , true , true , false, false, false, false, false, false],
    [true , false, true , false, true , true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , false, false, false, false, false, false],
    [true , true , true , true , true , true , true , true , true , true , false, false, false, false, false, false],
    [true , true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const DESERT_SUN: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, true , true , true , true , true , true , true , true , true , true , true , true , false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GENERIC_UNHOOKABLE: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, true , true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [true , true , true , false, true , false, false, true , true , true , false, true , false, false, false, false],
    [false, true , false, false, true , false, false, false, true , false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, true , false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , false, false, false, false, false, true , false, false, false, true , false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , true , false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, true , false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const GRASS_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, false, false, false, false, false, false, true , true , true , true , true ],
    [true , true , true , true , false, false, false, false, false, false, false, true , true , true , true , true ],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , true , true , true ],
    [true , true , true , true , false, true , true , false, false, false, false, false, false, true , true , true ],
    [true , true , true , true , true , true , true , false, true , true , true , false, false, false, false, false],
    [true , true , false, true , false, true , true , false, true , true , true , false, false, false, false, false],
    [false, false, true , true , false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [false, true , false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , true , true , false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const JUNGLE_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, true , true , true , true , true , true , true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, true , true , false, false, true , true , false],
    [false, false, false, false, false, false, false, false, false, true , false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , true , false, false, false, false, true , true , false, false, false, false, false, false],
];
const JUNGLE_MAIN: [[bool; 16]; 16] =
[
    [false, true , true , true , false, false, false, false, false, false, false, false, false, true , false, false],
    [true , true , true , true , false, false, false, false, false, false, false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , true , false, false],
    [true , true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [true , true , true , true , true , true , true , true , true , true , true , true , false, false, false, false],
    [true , true , false, false, false, false, false, true , true , true , true , true , false, false, false, false],
    [false, true , true , false, false, false, false, false, true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, true , false, true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const JUNGLE_MIDGROUND: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , false, false, false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , false, false, false, false, false],
    [false, true , true , true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, true , true , true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, true , false, false, true , false, false, false, false, false, false, false, false, false],
    [false, false, false, true , false, false, true , true , false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , true , true , false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , true , true , false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, true , false, true , false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const MOON: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, true , true , true , true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const SUN: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, true , true , true , true , true , true , true , true , true , true , false, false, false],
    [false, false, false, false, true , true , true , true , true , true , true , true , false, false, false, false],
    [false, false, false, false, false, true , true , true , true , true , true , false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
const WINTER_DOODADS: [[bool; 16]; 16] =
[
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, true , false, false, false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, true , true , true , false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, true , false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, true , true , true , false, false, false],
];
const WINTER_MAIN: [[bool; 16]; 16] =
[
    [false, true , false, true , true , false, false, false, false, true , true , true , true , true , true , true ],
    [false, true , true , true , false, false, true , true , false, true , true , true , true , true , true , true ],
    [false, true , true , true , true , true , true , true , true , false, true , true , true , true , true , false],
    [false, true , true , true , true , true , true , true , true , false, true , true , false, false, true , false],
    [false, true , true , true , true , true , true , true , true , false, true , false, false, false, true , false],
    [false, false, true , true , true , false, false, false, true , true , true , false, true , true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [true , false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, true , false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, true , false, false],
    [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false],
];
