TwMap Tools
===

Powered by the [twmap](https://crates.io/crates/twmap) library!

Overview
---

All tools are command line argument based and explain their usage with `--help`.

- `debug_load`: parse maps with different verbosity levels for debugging purposes
- `edit_map`: easily convert maps between different formats, with some fancy steps in between like mirroring
- `fix_map`: fix some common issues on maps which are not accepted by other executables
- `extract_files`: extract image and sound files from maps
- `extract_tileflags`: used on images, extracts the `TILEFLAG_OPAQUE` table used in tiles layers
- `check_ddnet`: scans ddnet maps for faulty behavior (e.g. falsely placed hook-through, invalid rotation of game tiles)

Installation
---

You need [Rust](https://www.rust-lang.org/tools/install) installed on your system.

Simply do `cargo install twmap-tools`

Manual Building
---

You need [Rust](https://www.rust-lang.org/tools/install) installed on your system.

To compile the tools in release mode, execute the following command in this directory or the project root:
```
cargo build --release
```
The executable files will be located at the **project root** in `target/release/`.

To compile the debug build instead, omit the `--release` flag.
Note that debug binaries will be significantly slower!
The executable files of debug builds will be located in `target/debug/`.
