# Twitch-RSS

Generates RSS feeds for Twitch accounts.

This acts as a proxy to Twitch, presenting video history as an RSS feed. The idea is that you can add specific accounts to your RSS reader as separate URLs/feeds.

You can run it in two modes:
- HTTP: A caching proxy to Twitch, presenting an HTTP endpoint that can be added to RSS readers
- CLI: Manual polling (without caching), the resulting feed can be published to a static site.

## Quickstart

In order to use this, you first need to create a [Twitch App](https://dev.twitch.tv/console/apps/create) and get the Client ID and Client Secret.
Those credentials will then be used by `twitch-rss` to query Twitch APIs.

To install `twitch-rss`, you can run `cargo install twitch-rss`. [Docker images](https://hub.docker.com/r/nickbp/twitch-rss/tags) for amd64/arm64 are also available, see the [Dockerfile](https://git.sr.ht/~nickbp/twitch-rss/tree/main/item/Dockerfile).

### HTTP

0. Prerequisites: Get your Twitch App credentials, and install `twitch-rss` using `cargo install twitch-rss`.
1. Start `twitch-rss` with `CLIENT_ID` and `CLIENT_SECRET` envvars containing the Twitch App credentials. You can optionally also specify `LISTEN`, `0.0.0.0:8080` is the default:
```
$ CLIENT_ID=1234...abcd \
    CLIENT_SECRET=5678...efgh \
    LISTEN=127.0.0.1:8080 \
    ./twitch-rss
```
2. Add `twitch-rss` URL(s) to your RSS reader (e.g. [`miniflux`](https://miniflux.app)), or test manually with `curl`:
```
$ curl -v 'http://127.0.0.1:8080/rss?account=ACCOUNT_NAME_HERE'
```

### CLI/stdout

Alternatively you can also run `twitch-rss` via the CLI with the account to query, and it will write the RSS to stdout. This is useful for testing or for writing the RSS payload to a static page.

```
$ CLIENT_ID=1234...abcd \
    CLIENT_SECRET=5678...efgh \
    ./twitch-rss ACCOUNT_NAME_HERE
```

## License

This project is [licensed](LICENCE.md) under the [FAFOL](https://git.sr.ht/~boringcactus/fafol/tree/master/README.md). This is intended to restrict use of the project for purposes that would be considered unethical by its authors.
