// SPDX-FileCopyrightText: 2022 Declan Rixon <twisted.cubing@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

use crate::cube::Face;
use sdl2::pixels::Color;

pub struct ColorScheme([Color; 7]);

pub const COLOR_SCHEME_STANDARD: ColorScheme = ColorScheme([
    /* U */ Color::RGB(255, 255, 255),
    /* D */ Color::RGB(255, 231, 51),
    /* F */ Color::RGB(1, 166, 92),
    /* B */ Color::RGB(25, 59, 255),
    /* R */ Color::RGB(184, 0, 0),
    /* L */ Color::RGB(253, 106, 0),
    /* Background */ Color::RGB(20, 20, 20),
]);

pub const COLOR_SCHEME_VI: ColorScheme = ColorScheme([
    /* U */ Color::RGB(20, 20, 20),
    /* D */ Color::RGB(255, 231, 51),
    /* F */ Color::RGB(1, 166, 92),
    /* B */ Color::RGB(180, 9, 203),
    /* R */ Color::RGB(184, 0, 0),
    /* L */ Color::RGB(253, 106, 0),
    /* Background */ Color::RGB(230, 230, 230),
]);

impl ColorScheme {
    pub fn color(&self, face: Face) -> Color {
        self.0[match face {
            Face::U => 0,
            Face::D => 1,
            Face::F => 2,
            Face::B => 3,
            Face::R => 4,
            Face::L => 5,
        }]
    }

    pub fn background(&self) -> Color {
        self.0[6]
    }
}
