// SPDX-FileCopyrightText: 2022 Declan Rixon <twisted.cubing@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

// U Layer (top-down):
// #0#
// 3#1
// #2#
// E Layer (top-down):
// 4#5
// ###
// 7#6
// D Layer (top-down):
// ##08##
// 11##09
// ##10##
pub mod edge {
    pub static U: [usize; 4] = [0, 1, 2, 3];
    pub static D: [usize; 4] = [10, 9, 8, 11];
    pub static R: [usize; 4] = [5, 9, 6, 1];
    pub static L: [usize; 4] = [4, 3, 7, 11];
    pub static F: [usize; 4] = [2, 6, 10, 7];
    pub static B: [usize; 4] = [8, 5, 0, 4];
}
// U Layer (top-down):
// 0#1
// ###
// 3#2
// D Layer (top-down):
// 4#5
// ###
// 7#6
pub mod corner {
    pub static U: [usize; 4] = [0, 1, 2, 3];
    pub static D: [usize; 4] = [7, 6, 5, 4];
    pub static R: [usize; 4] = [1, 5, 6, 2];
    pub static L: [usize; 4] = [4, 0, 3, 7];
    pub static F: [usize; 4] = [3, 2, 6, 7];
    pub static B: [usize; 4] = [4, 5, 1, 0];
}
