// SPDX-FileCopyrightText: 2022 Declan Rixon <twisted.cubing@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

pub mod moyu_weilong_ai;

use crate::cube::Move;
use async_trait::async_trait;
use bluer::Address;
use std::io;

pub type Result<T> = std::result::Result<T, RecordingError>;

pub enum RecordingError {
    IO(io::Error),
    BlueR(bluer::Error),
}

#[async_trait]
pub trait Connection {
    async fn is_connected(&self) -> bluer::Result<bool>;
    async fn get_connected(&self) -> Address;
    async fn stop_recording(&mut self);
    async fn get_buffer(&mut self) -> Option<Vec<Move>>;
    async fn record_to_buffer(&mut self) -> Result<()>;
    async fn record_to_files(&mut self, stem: &str) -> Result<()>;
}
