// SPDX-FileCopyrightText: 2022 Declan Rixon <twisted.cubing@gmail.com>
//
// SPDX-License-Identifier: GPL-3.0-only

// Exports
pub mod hsc;
pub type Breakdown = Vec<SubstepSolution>;
pub mod builder;
pub use shared::substep;

// External submodules
mod shared;

use crate::cube::Move;

pub trait Substep {
    // Create a new instance of this model for a solved cube.
    fn new() -> Self;
    // Retrieve the state after the given moves are applied.
    fn after_moves(&self, moves: &[Move]) -> Self;
    // Check if this substep has been completed.
    fn solved(&self) -> bool;
    // The comment to use in solve reconstructions.
    fn comment() -> &'static str;
}

pub struct SubstepSolution {
    pub comment: &'static str,
    pub solution: Vec<Move>,
}

#[derive(Debug)]
pub enum BreakdownError {}

pub trait Method {
    fn breakdown(&self, scramble: &[Move], solution: &[Move]) -> Result<Breakdown, BreakdownError>;
}
