use twilight_model::user::User;

/// Trait to be implemented on `User`
pub trait UserTrait {
    /// Returns the URL to the user's avatar
    fn avatar(&self) -> String;
}

impl UserTrait for User {
    fn avatar(&self) -> String {
        match &self.avatar {
            Some(hash) => {
                let extension = if hash.starts_with("_a") { "gif" } else { "png" };
                format!(
                    "https://cdn.discordapp.com/avatars/{}/{}.{}",
                    self.id, hash, extension
                )
            }
            None => format!(
                "https://cdn.discordapp.com/embed/avatars/{}.png",
                self.discriminator
                    .chars()
                    .last()
                    .unwrap()
                    .to_digit(10)
                    .unwrap()
                    % 5
            ),
        }
    }
}
