use twilight_embed_builder::{image_source::ImageSourceUrlError, EmbedAuthorBuilder, ImageSource};
use twilight_model::{channel::embed::EmbedAuthor, guild::Member, user::User};

use super::{member::MemberTrait, user::UserTrait};

/// Trait to create an `EmbedAuthor` using the  `Member` or `User`'s nick/username and profile picture
pub trait EmbedAuthorTrait {
    /// Creates an `EmbedAuthor` with the member's nick/username and profile picture
    fn from_member(member: &Member) -> Result<EmbedAuthor, ImageSourceUrlError>;
    /// Creates an `EmbedAuthor` with the `user`'s username and profile picture
    fn from_user(member: &User) -> Result<EmbedAuthor, ImageSourceUrlError>;
}

impl EmbedAuthorTrait for EmbedAuthor {
    fn from_member(member: &Member) -> Result<EmbedAuthor, ImageSourceUrlError> {
        Ok(EmbedAuthorBuilder::new()
            .name(member.name())
            .icon_url(ImageSource::url(member.user.avatar())?)
            .build())
    }

    fn from_user(user: &User) -> Result<EmbedAuthor, ImageSourceUrlError> {
        Ok(EmbedAuthorBuilder::new()
            .name(user.name.clone())
            .icon_url(ImageSource::url(user.avatar())?)
            .build())
    }
}
