use twilight_model::{
    application::command::permissions::{CommandPermissions, CommandPermissionsType},
    id::{RoleId, UserId},
};

/// Trait to create `CommandPermissions` from a `UserId` or `RoleId`
pub trait CommandPermissionsTrait {
    /// Creates `CommandPermissions` from a `UserId` that enables by default
    fn from_user(user_id: UserId) -> Self;
    /// Creates `CommandPermissions` from a `RoleId` that enables by default
    fn from_role(role_id: RoleId) -> Self;
    /// Makes the `CommandPermissions` disable instead of enabling
    fn disable(&mut self);
}

impl CommandPermissionsTrait for CommandPermissions {
    fn from_user(user_id: UserId) -> Self {
        CommandPermissions {
            id: CommandPermissionsType::User(user_id),
            permission: true,
        }
    }

    fn from_role(role_id: RoleId) -> Self {
        CommandPermissions {
            id: CommandPermissionsType::Role(role_id),
            permission: true,
        }
    }

    fn disable(&mut self) {
        self.permission = false;
    }
}
