use twilight_http::{request::application::InteractionCallback, Client};
use twilight_model::application::{
    callback::{CallbackData, InteractionResponse},
    interaction::ApplicationCommand,
};

pub mod command_builder;
pub mod command_data_options;
pub mod command_permissions;
pub mod interaction;

static EMPTY_CALLBACK_DATA: InteractionResponse =
    InteractionResponse::DeferredChannelMessageWithSource(CallbackData {
        content: None,
        embeds: Vec::new(),
        components: None,
        allowed_mentions: None,
        flags: None,
        tts: None,
    });

/// Trait to acknowledge an `ApplicationCommand`, showing a loading state
///
/// It is preferred to ack a command first because Discord gives a 3 second window to respond to a command
pub trait Ack {
    fn ack<'a>(&'a self, http: &'a Client) -> InteractionCallback<'a>;
}

impl Ack for ApplicationCommand {
    /// Acknowledges an `ApplicationCommand`, showing a loading state
    fn ack<'a>(&'a self, http: &'a Client) -> InteractionCallback<'a> {
        http.interaction_callback(self.id, &self.token, &EMPTY_CALLBACK_DATA)
    }
}
