use twilight_model::guild::Member;

/// Trait to be implemented on `Member`
pub trait MemberTrait {
    fn name(&self) -> String;
}

impl MemberTrait for Member {
    /// Returns `member`'s nick, falling back to their username
    fn name(&self) -> String {
        self.nick.clone().unwrap_or(self.user.name.clone())
    }
}
