use twilight_model::application::command::{Command, CommandOption};

/// Builder struct to create a `Command`
pub struct CommandBuilder {
    name: String,
    description: String,
    options: Vec<CommandOption>,
    default_permission: Option<bool>,
}

impl CommandBuilder {
    /// Creates a `CommandBuilder` with just the `name` and `description` fields set
    pub fn new(name: String, description: String) -> CommandBuilder {
        CommandBuilder {
            name,
            description,
            options: Vec::new(),
            default_permission: None,
        }
    }

    /// Adds a `CommandOption` to the command
    pub fn add_option(&mut self, option: CommandOption) {
        self.options.push(option);
    }

    /// Makes the command disabled by default
    pub fn default_permission_false(&mut self) {
        self.default_permission = Some(false)
    }

    /// Consumes the builder and builds the `Command`
    pub fn build(self) -> Command {
        Command {
            name: self.name,
            description: self.description,
            options: self.options,
            default_permission: self.default_permission,
            application_id: None,
            guild_id: None,
            id: None,
        }
    }
}
