use std::{
    fs::read_dir,
    path::{Path, PathBuf},
    str::FromStr,
};

pub type TuckErr = anyhow::Error;

#[derive(Debug)]
pub struct TuckDir {
    path: PathBuf,
}

impl FromStr for TuckDir {
    type Err = TuckErr;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        let path = PathBuf::from_str(s)?;
        Ok(Self { path })
    }
}

impl TuckDir {
    fn walk(path: &Path, target: &Path) -> Result<Vec<TuckEntry>, TuckErr> {
        dbg!(target);

        let mut entries = vec![];

        if path.is_dir() {
            for entry in read_dir(path)? {
                let entry = entry?;

                // TODO: which paths should be linked to --target

                entries.push(TuckEntry::new(entry.path()));
            }
        } else {
            entries.push(TuckEntry::new(path.to_path_buf()))
        }

        Ok(entries)
    }

    pub fn entries(&self, target: &Path) -> Result<Vec<TuckEntry>, TuckErr> {
        Self::walk(&self.path, target)
    }
}

#[derive(Debug)]
pub struct TuckEntry {
    path: PathBuf,
}

impl TuckEntry {
    const DOT: &'static str = "dot-";

    pub fn new(entry: PathBuf) -> Self {
        Self { path: entry }
    }

    pub fn replace_dot(&mut self) {
        if let Some(x) = &self.path.file_name() {
            let renamed = x.to_str().unwrap_or_default().replace(Self::DOT, ".");
            self.path.set_file_name(renamed);
        }
    }

    pub fn link(target: &Path) {
        dbg!(target);
        todo!()
    }
}
