pub use super::*;

pub fn generate(lexer_res: Vec<Token>) -> Result<Vec<Byte>, String> {
    let mut res: Vec<Byte> = Vec::new();
    let mut idx: usize = 0;

    let copy_vec = lexer_res.clone();

    for e in copy_vec.iter() {
        let tok = e.clone();

        if tok == Token::new(ID_TOKEN, String::from("write_scr")) {
            res.push(WRITE_SCR);
            
            let next = match copy_vec.get(idx + 1) {
                Some(some) => some.clone(),
                None => return Err(format!("index + 1 ({}) exceeds the limit ({})", idx + 1, lexer_res.len()))
            };

            if next.token_type == INT_TOKEN {
                res.push(match next.token_value.parse::<u8>() {
                    Ok(ok) => ok,
                    Err(_err) => return Err(format!("failed to parse {:?} into u8", next.token_value))
                });
            } else {
                return Err(format!("expected INT_TOKEN next to 'write_scr'"));
            }
        }

        idx = idx + 1;
    }

    Ok(res)
}
