pub use super::*;

pub fn execute(rtne: Routine) -> Option<usize> {
    let mut clock: usize = 0;
    let mut byte = match rtne.get(clock) {
        Ok(ok) => ok,
        Err(_err) => return Some(clock)
    };

    loop {
        if byte == WRITE_SCR {
            let next = match rtne.get(clock + 1) {
                Ok(ok) => ok,
                Err(_err) => return Some(clock)
            };

            print!("{}", next as u8 as char);
        }

        if clock + 1 >= rtne.len() {
            break;
        }

        clock = clock + 1;
    
        byte = match rtne.get(clock) {
            Ok(ok) => ok,
            Err(_err) => return Some(clock)
        };
    }

    None
}
