use std::{fs, io::{Read, Write}};

pub use super::*;

pub fn read_to_end(fname: String) -> Result<Vec<Byte>, String> {
    let mut fp = match fs::File::open(fname) {
        Ok(ok) => ok,
        Err(err) => return Err(format!("{:?}", err))
    };

    let mut buf: Vec<Byte> = Vec::new();
    let _fsize = match fp.read_to_end(&mut buf) {
        Ok(ok) => ok,
        Err(err) => return Err(format!("{:?}", err))
    };

    Ok(buf)
}

pub fn write_all(fname: String, bytecode: Vec<Byte>) -> Option<String> {
    let mut fp = match fs::File::open(fname) {
        Ok(ok) => ok,
        Err(err) => return Some(format!("{:?}", err))
    };

    match fp.write_all(&bytecode) {
        Ok(_ok) => return None,
        Err(err) => return Some(format!("{:?}", err))
    };
}
