use std::{fs, io::Read};

pub use super::*;

pub fn read_to_end(fname: String) -> Result<Vec<Byte>, String> {
    let mut fp = match fs::File::open(fname) {
        Ok(ok) => ok,
        Err(err) => return Err(format!("{:?}", err))
    };

    let mut buf: Vec<Byte> = Vec::new();
    let _fsize = match fp.read_to_end(&mut buf) {
        Ok(ok) => ok,
        Err(err) => return Err(format!("{:?}", err))
    };

    Ok(buf)
}

pub fn read_to_routine(fname: String) -> Result<Routine, String> {
    let vec = match read_to_end(fname) {
        Ok(ok) => ok.clone(),
        Err(err) => return Err(err.clone())
    };

    Ok(Routine::from(vec))
}
