pub use super::*;

pub type TokenType = u16;

pub const ID_TOKEN: TokenType = 10 << 1;
pub const CHAR_TOKEN: TokenType = 20 << 2;
pub const HEX_TOKEN: TokenType = 30 << 3;
pub const INT_TOKEN: TokenType = 40 << 4;

#[derive(Clone, Debug, PartialEq)]
pub struct Token {
    pub token_type: TokenType,
    pub token_value: String
}

impl Token {
    pub fn new(token_type: TokenType, token_value: String) -> Token {
        Token {
            token_type,
            token_value
        }
    }
}
