pub use super::*;

pub struct Pos {
    src: String,
    pub chr: char,
    pub pos: usize,
    pub lno: usize,
    pub onl: usize
}

impl Pos {
    pub fn from(src: String) -> Result<Pos, String> {
        let pos = Pos {
            src: format!("{}\0", src),
            chr: match src.chars().nth(0) {
                Some(some) => some,
                None => return Err(format!("src.len() ({}) is under 1", src.len()))
            },
            pos: 0,
            lno: 0,
            onl: 0
        };

        Ok(pos)
    }

    pub fn has_next(&mut self) -> bool {
        self.pos + 1 < self.src.len()
    }

    pub fn next(&mut self) -> Option<String> {
        if self.has_next() {
            self.pos = self.pos + 1;
            self.chr = match self.src.chars().nth(self.pos) {
                Some(some) => some,
                None => return Some(format!("self.pos ({}) exceeds self.src.len() ({})", self.pos, self.src.len()))
            };

            self.onl = self.onl + 1;

            if self.chr == '\n' {
                self.lno = self.lno + 1;
                self.onl = 0;
            }
            
            None
        } else {
            Some(format!("self.pos + 1 ({}) exceeds self.src.len() ({})", self.pos + 1, self.src.len()))
        }
    }
}
