pub use super::*;

pub struct Lexer {
    pub src: String,
    res: Vec<Token>,
    pos: Pos
}

impl Lexer {
    pub fn from(src: String) -> Result<Lexer, String> {
        let lexer = Lexer {
            src: src.clone(),
            res: Vec::new(),
            pos: Pos::from(src)?
        };

        Ok(lexer)
    }

    pub fn lex(&mut self) -> Result<Vec<Token>, String> {
        while self.pos.has_next() {
            if String::from(" \n\r\t").contains(self.pos.chr) {
                match self.pos.next() {
                    Some(some) => return Err(some.clone()),
                    None => ()
                }
            } else if String::from("qwertyuopasdfghjklizxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM_").contains(self.pos.chr) {
                let mut id = String::new();
                let mut idx: usize = 0;

                while String::from("qwertyuopasdfghjklizxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM_").contains(self.pos.chr) {
                    id.push(self.pos.chr);

                    idx = idx + 1;

                    match self.pos.next() {
                        Some(some) => return Err(some.clone()),
                        None => ()
                    }
                }

                self.res.push(Token::new(ID_TOKEN, id));
            } else {
                match self.pos.next() {
                    Some(some) => return Err(some),
                    None => ()
                };
            }
        }

        Ok(self.res.clone())
    }
}

pub fn delex(vec: Vec<Token>) -> String {
    let mut res: String = String::new();

    for e in vec {
        res.push_str(format!("{} ", e.token_value).as_str());
    }

    res
}
