pub use super::*;

pub struct Routine {
    code: Vec<Byte>
}

impl Routine {
    pub fn new() -> Routine {
        Routine {
            code: Vec::new()
        }
    }

    pub fn from(code: Vec<Byte>) -> Routine {
        Routine {
            code
        }
    }

    pub fn push(&mut self, op: Byte) {
        self.code.push(op)
    }

    pub fn pop(&mut self) -> Option<Byte> {
        self.code.pop()
    }

    pub fn get(&self, index: usize) -> Result<Byte, String> {
        if index < self.len() {
            Ok(self.code[index])
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn len(&self) -> usize {
        self.code.len()
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.code.clone()
    }
}
