pub use super::*;

pub type Byte = u128;

pub struct Immut {
    memory: Vec<Byte>
}

impl Immut {
    pub fn new(size: usize) -> Immut {
        Immut {
            memory: vec![0x0; size]
        }
    }

    pub fn from(memory: Vec<Byte>) -> Immut {
        Immut {
            memory
        }
    }

    pub fn from_mut(mut_mem: Mut) -> Immut {
        let memory_clone: Vec<Byte> = mut_mem.clone_into_vec();

        Immut {
            memory: memory_clone
        }
    }

    pub fn get(&self, index: usize) -> Result<Byte, String> {
        if index < self.len() {
            Ok(self.memory[index])
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn len(&self) -> usize {
        self.memory.len()
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.memory.clone()
    }
}

pub struct Mut {
    size: usize,
    memory: Vec<Byte>
}

impl Mut {
    pub fn new(size: usize) -> Mut {
        Mut {
            size,
            memory: vec![0x0; size]
        }
    }

    pub fn from(memory: Vec<Byte>) -> Mut {
        Mut {
            size: memory.len(),
            memory
        }
    }

    pub fn from_immut(immut: Immut) -> Mut {
        let memory_clone = immut.clone_into_vec();
        
        Mut {
            size: memory_clone.len(),
            memory: memory_clone
        }
    }

    pub fn set(&mut self, index: usize, byte: Byte) -> Result<(), String> {
        if index < self.len() {
            self.memory[index] = byte;
            
            Ok(())
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn get(&self, index: usize) -> Result<Byte, String> {
        if index < self.len() {
            Ok(self.memory[index])
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn len(&self) -> usize {
        self.size
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.memory.clone()
    }
}
