pub mod mem;

pub use mem::*;

#[cfg(test)]
mod tests {
    
    #[test]
    fn test_immut() {
        use crate::*;

        fn test_new() {
            let immut_mem = Immut::new(12);

            let _get_ok = match immut_mem.get(11) {
                Ok(ok) => assert_eq!(ok, 0x0),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match immut_mem.get(12) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(immut_mem.len(), 12);
            assert_eq!(immut_mem.clone_into_vec(), vec![0x0; 12]);
        }

        fn test_from() {
            let immut_mem = Immut::from(vec![1, 2, 3, 4, 5]);

            let _get_ok = match immut_mem.get(2) {
                Ok(ok) => assert_eq!(ok, 3),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match immut_mem.get(5) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(immut_mem.len(), 5);
            assert_eq!(immut_mem.clone_into_vec(), vec![1, 2, 3, 4, 5]);
        }

        fn test_from_mut() {
            let mut_mem = Mut::from(vec![1, 2, 3, 4, 5]);
            let immut_mem = Immut::from_mut(mut_mem);

            let _get_ok = match immut_mem.get(2) {
                Ok(ok) => assert_eq!(ok, 3),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match immut_mem.get(5) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(immut_mem.len(), 5);
            assert_eq!(immut_mem.clone_into_vec(), vec![1, 2, 3, 4, 5]);
        }
        
        test_new();
        test_from();
        test_from_mut()
    }

    #[test]
    fn test_mut() {
        use crate::*;

        fn test_new() {
            let mut mut_mem = Mut::new(12);
            let index11 = '😎' as Byte;

            let _set_ok = match mut_mem.set(11, index11) {
                Ok(ok) => assert_eq!(ok, ()),
                Err(err) => panic!("{}", err)
            };

            let _set_err = match mut_mem.set(12, 0x0) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            let _get_ok = match mut_mem.get(11) {
                Ok(ok) => assert_eq!(ok, index11),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match mut_mem.get(12) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(mut_mem.len(), 12);
            assert_eq!(mut_mem.clone_into_vec(), vec![0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, index11]);
        }

        test_new();
    }
}
