pub use super::*;

pub type Byte = u128;

pub struct Immut {
    memory: Vec<Byte>
}

impl Immut {
    pub fn new(size: usize) -> Immut {
        Immut {
            memory: vec![0x0; size]
        }
    }

    pub fn from(memory: Vec<Byte>) -> Immut {
        Immut {
            memory
        }
    }

    pub fn get(&self, index: usize) -> Result<Byte, String> {
        if index < self.len() {
            Ok(self.memory[index])
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn len(&self) -> usize {
        self.memory.len()
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.memory.clone()
    }
}
