pub mod mem;

pub use mem::*;

#[cfg(test)]
mod tests {
    
    #[test]
    fn test_immutable() {
        use crate::*;

        fn test_new() {
            let const_mem = Immutable::new(12);

            let _get_ok = match const_mem.get(11) {
                Ok(ok) => assert_eq!(ok, 0x0),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match const_mem.get(12) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(const_mem.len(), 12);
            assert_eq!(const_mem.clone_into_vec(), vec![0x0; 12]);
        }

        fn test_from() {
            let const_mem = Immutable::from(vec![1, 2, 3, 4, 5]);

            let _get_ok = match const_mem.get(2) {
                Ok(ok) => assert_eq!(ok, 3),
                Err(err) => panic!("{}", err)
            };

            let _get_err = match const_mem.get(5) {
                Ok(_ok) => assert!(false),
                Err(_err) => assert!(true)
            };

            assert_eq!(const_mem.len(), 5);
            assert_eq!(const_mem.clone_into_vec(), vec![1, 2, 3, 4, 5]);
        }
        
        test_new();
        test_from();
    }
}
