pub use super::*;

pub type Byte = u128;

pub struct Const {
    memory: Vec<Byte>
}

impl Const {
    pub fn new(size: usize) -> Const {
        Const {
            memory: vec![0x0; size]
        }
    }

    pub fn from(memory: Vec<Byte>) -> Const {
        Const {
            memory
        }
    }

    pub fn get(&self, index: usize) -> Result<Byte, String> {
        if index < self.len() {
            Ok(self.memory[index])
        } else {
            Err(format!("index ({}) exceeds the size ({})", index, self.len()))
        }
    }

    pub fn len(&self) -> usize {
        self.memory.len()
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.memory.clone()
    }
}
