use super::*;

pub const MEMORY_SIZE: usize = 0xFFFF * 8;
pub const DISKPORT_SIZE: usize = 3;

pub struct Device {
    pub mem: Box<[u8]>,
    pub disks: Vec<*mut Disk>,
    pub disk_ptr: usize
}

impl Device {
    pub fn new() -> Device {
        Device {
            mem: vec![0; MEMORY_SIZE].into_boxed_slice(),
            disks: vec![],
            disk_ptr: 0
        }
    }

    pub fn power_on(&mut self) {
        
    }

    pub fn insert(&mut self, disk: &mut Disk) -> Option<String> {
        if self.disk_ptr + 1 < DISKPORT_SIZE {
            self.disk_ptr = self.disk_ptr + 1;

            self.disks[self.disk_ptr - 1] = disk;

            Option::None
        } else {
            Some(format!("disk pointer ({}) exceeds the limit ({})", self.disk_ptr, DISKPORT_SIZE))
        }
    }
}
