use super::host;
use super::vm;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub enum Parent {
    VM(*mut vm::VM),
    Host(host::Host),
}

impl Parent {
    pub fn from_vm(vm: &mut vm::VM) -> Self {
        Parent::VM(vm)
    }

    pub fn from_host(host: &host::Host) -> Self {
        Parent::Host(host.clone())
    }
}
