// Unsigned
pub type Byte = u8;
pub type UShort = u16;
pub type UInt = u32;
pub type ULong = u64;
pub type Char = u16;
pub type Ref = u64;
pub type ThrId = u64;
pub type Err = u8;
pub type CallId = u8;

// Signed
pub type Int = i32;
pub type Long = i64;
pub type SChar = i16;
pub type SByte = i8;
pub type Short = i16;
pub type SRef = i64;
pub type SThrId = i64;
pub type SErr = i8;
pub type SCallId = i8;

// Calls
pub fn exit() -> CallId {
    0xFF
}

pub fn throw() -> CallId {
    0xFE
}

pub fn alloc() -> CallId {
    0xFD
}

pub fn dealloc() -> CallId {
    0xFC
}

pub fn push() -> CallId {
    0xFB
}

pub fn pop() -> CallId {
    0xFA
}

pub fn vmcreate() -> CallId {
    0xF9
}

pub fn vmstart() -> CallId {
    0xF8
}

pub fn vmdestroy() -> CallId {
    0xF7
}

pub fn vmload() -> CallId {
    0xF6
}

// Register IDs
pub const CARRY: usize = 0;
pub const ERROR: usize = 1;
