use super::*;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct RAM {
    inner: Box<[u8]>,
    capacity: usize,
}

impl RAM {
    pub fn new() -> Self {
        RAM::with_capacity(1 << 30)
    }

    pub fn with_capacity(capacity: usize) -> Self {
        RAM {
            inner: vec![0; capacity].into_boxed_slice(),
            capacity,
        }
    }
}

impl IO for RAM {
    fn read(&self, addr: usize, byte: &mut u8) {
        if addr < self.capacity {
            *byte = self.inner[addr];
        }
    }

    fn write(&mut self, addr: usize, byte: u8) {
        if addr < self.capacity {
            self.inner[addr] = byte;
        }
    }

    fn capacity(&self) -> usize {
        self.capacity
    }
}

pub trait RAMSupport {
    fn connect(&mut self, ram: &mut RAM, port: usize);
    fn disconnect(&mut self, port: usize);
    fn is_connected(&self) -> bool;
}
