use super::*;

#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord)]
pub struct Bus<T: IO> {
    dev: *mut T,
}

impl<T: IO> Bus<T> {
    pub fn new(dev: &mut T) -> Self {
        Bus { dev }
    }
}

impl<T: IO> IO for Bus<T> {
    fn read(&self, addr: usize, byte: &mut u8) {
        unsafe {
            (*self.dev).read(addr, byte);
        }
    }

    fn write(&mut self, addr: usize, byte: u8) {
        unsafe {
            (*self.dev).write(addr, byte);
        }
    }

    fn capacity(&self) -> usize {
        unsafe { (*self.dev).capacity() }
    }
}
