use std::ops;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct ROM {
    data: Box<[u8]>,
}

impl ROM {
    pub fn from(data: &[u8]) -> Self {
        ROM {
            data: data.to_vec().into_boxed_slice(),
        }
    }

    pub fn get(&self, addr: usize) -> Option<&u8> {
        self.data.get(addr)
    }

    pub fn len(&self) -> usize {
        self.data.len()
    }
}

impl ops::Index<usize> for ROM {
    type Output = u8;

    fn index(&self, addr: usize) -> &Self::Output {
        self.data.get(addr).unwrap()
    }
}
