use super::*;
use std::fs::File;
use std::io::Read;
use std::path::Path;

pub fn from(data: &[u8]) -> ROM {
    ROM::from(data)
}

pub fn from_file<P: AsRef<Path>>(path: P) -> Result<ROM, LoadError> {
    let mut file = match File::open(path) {
        Ok(file) => file,
        Err(err) => return Err(LoadError::new(&format!("{}", err))),
    };

    let mut buf: Vec<u8> = Vec::new();

    match file.read_to_end(&mut buf) {
        Ok(_) => (),
        Err(err) => return Err(LoadError::new(&format!("{}", err))),
    };

    Ok(from(&buf))
}

pub type LoadError = mtk::Error;
