pub trait IODev {
    fn read(&self, addr: usize) -> Result<&u8, IOError>;
    fn read_mut(&mut self, addr: usize) -> Result<&mut u8, IOError>;
    fn write(&mut self, addr: usize, data: u8) -> Result<usize, IOError>;
    fn size(&self) -> usize;
}

pub type IOError = mtk::Error;
