fn exit(code: i32) -> ! {
    use std::process;

    process::exit(code)
}

fn main() {
    let argv = rsap::collect();

    if argv.len() < 2 {
        mtk::eprintln(&mtk::Title::new("tt64"), "no input file");

        exit(1);
    }

    let path: String;

    if rsap::contains("l", &argv) {
        path = match rsap::get("l", &argv) {
            Ok(ok) => ok,
            Err(err) => {
                mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                exit(1);
            }
        };
    } else if rsap::contains("load", &argv) {
        path = match rsap::get("load", &argv) {
            Ok(ok) => ok,
            Err(err) => {
                mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                exit(1);
            }
        };
    } else {
        mtk::eprintln(&mtk::Title::new("tt64"), "exptected `-l` or `--load`");

        exit(1);
    }

    let memsize: usize;

    if rsap::contains("m", &argv) {
        memsize = match rsap::get("m", &argv) {
            Ok(ok) => match ok.parse() {
                Ok(ok) => ok,
                Err(err) => {
                    mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                    exit(1);
                }
            },
            Err(err) => {
                mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                exit(1);
            }
        };
    } else if rsap::contains("memory-size", &argv) {
        memsize = match rsap::get("memory-size", &argv) {
            Ok(ok) => match ok.parse() {
                Ok(ok) => ok,
                Err(err) => {
                    mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                    exit(1);
                }
            },
            Err(err) => {
                mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

                exit(1);
            }
        };
    } else {
        memsize = 1 << 30;
    }

    let bin = match ttvm::load::from_file(&path) {
        Ok(ok) => ok,
        Err(err) => {
            mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

            exit(1);
        }
    };

    let mut main_disk = ttvm::Disk::from_rom(&bin);

    let mut mem = ttvm::Mem::new(memsize);
    let mut cpu = ttvm::CPU::new(&mut mem);

    match cpu.attach_disk(&mut main_disk, 0) {
        Ok(_) => (),
        Err(err) => {
            mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

            exit(1);
        }
    };

    cpu.power();

    match cpu.detach_disk(0) {
        Ok(_) => (),
        Err(err) => {
            mtk::eprintln(&mtk::Title::new("tt64"), &err.to_string());

            exit(1);
        }
    };
}
