use super::*;

#[test]
fn test_byte() {
    assert_eq!(Byte::MIN, i64::MIN);
    assert_eq!(Byte::MAX, i64::MAX);

    #[cfg(target_pointer_width = "64")]
    assert_eq!(WByte::MIN, i128::MIN);

    #[cfg(target_pointer_width = "64")]
    assert_eq!(WByte::MAX, i128::MAX);

    #[cfg(target_pointer_width = "32")]
    assert_eq!(WByte::MIN, i64::MIN);

    #[cfg(target_pointer_width = "32")]
    assert_eq!(WByte::MAX, i64::MAX);
}

#[test]
fn test_mem() {
    let mut mem = Mem::new();

    assert_eq!(mem.len(), 1);
    assert_eq!(mem.to_string(), "0x0 ");
    
    let addr = match mem.allocate(4) {
        Ok(ok) => ok,
        Err(err) => panic!("{}", err.to_string())
    };

    (*match mem.get_mut(addr) {
        Some(some) => some,
        None => panic!("{}", "mem.get_mut(addr) is None")
    })[2] = 0x1;

    match mem.get(addr) {
        Some(some) => assert_eq!(*some, vec![0x0, 0x0, 0x1, 0x0].into_boxed_slice()),
        None => panic!("{}", "mem.get(addr) is None")
    };

    let size = match mem.deallocate(addr) {
        Ok(ok) => ok,
        Err(err) => panic!("{}", err.to_string())
    };

    assert_eq!(addr, 1);
    assert_eq!(size, 4);
}
