use std::fs::File;
use std::io::Write;

pub fn write<S: AsRef<str>>(fname: S, code: Vec<i128>) -> Result<usize, mtk::FileError> {
    let mut res = String::new();
    let mut file = match File::create(fname.as_ref()) {
        Ok(ok) => ok,
        Err(_err) => match File::open(fname.as_ref()) {
            Ok(ok) => ok,
            Err(err) => return Err(mtk::FileError::from(err.to_string()))
        }
    };

    for elem in code {
        res += &elem.to_string();
    }
    
    match file.write(unsafe { res.as_mut_vec() }) {
        Ok(ok) => return Ok(ok),
        Err(err) => return Err(mtk::FileError::from(err.to_string()))
    };
}
