use super::parse;
use std::fs::File;
use std::io::Read;

pub fn read<S: AsRef<str>>(fname: S) -> Result<Vec<i128>, mtk::FileError> {
    let mut file = match File::open(fname.as_ref()) {
        Ok(ok) => ok,
        Err(err) => return Err(mtk::FileError::from(err.to_string()))
    };

    let mut content = String::new();
    
    match file.read_to_string(&mut content) {
        Ok(_ok) => Ok(match parse(content) {
            Ok(ok) => ok,
            Err(err) => return Err(err.clone())
        }),
        Err(err) => Err(mtk::FileError::from(err.to_string()))
    }
}
