use super::*;

pub type ParseError = mtk::ValueError;

pub fn parse<S: AsRef<str>>(src: S) -> Result<Vec<i128>, ParseError> {
    let mut res: Vec<i128> = Vec::new();
    let lexed = split(src.as_ref().to_string());

    for elem in lexed {
        res.push(match elem.parse::<i128>() {
            Ok(ok) => ok,
            Err(err) => return Err(ParseError::from(err.to_string()))
        });
    }

    Ok(res)
}
