fn exit(code: i32) -> ! {
    unsafe {
        libc::exit(code as libc::c_int)
    }
}

fn main() {
    let mut cli = mtk::CLI::new("ttvm");
    let parser = rsap::Parser::new();
    
    let run: String;
    let mut dump = false;
    let mut verbose = false;

    if parser.contains("r") {
        run = match parser.value_of("r") {
            Ok(ok) => ok,
            Err(err) => {
                cli.eprintln("argument parse error", &err.to_string());

                exit(1);
            }
        };
    } else {
        cli.eprintln("argument parse error", "missing argument: `r`");

        exit(1);
    }
    
    if parser.contains("d") || parser.contains("dump") {
        dump = true;
    }

    if parser.contains("v") || parser.contains("verbose") {
        verbose = true;
    }

    let run_content = match ttvm::ir::read(run) {
        Ok(ok) => ok,
        Err(err) => {
            cli.eprintln("file read error", &err.to_string());

            exit(1);
        }
    };

    let mut env = ttvm::Env::new();

    let err_addr = match env.alloc(5) {
        Ok(ok) => ok,
        Err(err) => {
            cli.eprintln("memory allocation error", &err.to_string());

            exit(1);
        }
    };

    match env.get_mem_mut().get_mut(err_addr) {
        Some(some) => {
            match some {
                Some(some) => {
                    *match some.get_mut(0) {
                        Some(some) => some,
                        None => {
                            cli.eprintln("memory allocation error", "failed to get mutable reference to memory");
                        
                            exit(1);
                        }
                    } = 'e' as u8 as i128;
                    
                    *match some.get_mut(1) {
                        Some(some) => some,
                        None => {
                            cli.eprintln("memory allocation error", "failed to get mutable reference to memory");
                        
                            exit(1);
                        }
                    } = 'r' as u8 as i128;
                    
                    *match some.get_mut(2) {
                        Some(some) => some,
                        None => {
                            cli.eprintln("memory allocation error", "failed to get mutable reference to memory");
                        
                            exit(1);
                        }
                    } = 'r' as u8 as i128;
                    
                    *match some.get_mut(3) {
                        Some(some) => some,
                        None => {
                            cli.eprintln("memory allocation error", "failed to get mutable reference to memory");
                        
                            exit(1);
                        }
                    } = 'o' as u8 as i128;
                    
                    *match some.get_mut(4) {
                        Some(some) => some,
                        None => {
                            cli.eprintln("memory allocation error", "failed to get mutable reference to memory");
                        
                            exit(1);
                        }
                    } = 'r' as u8 as i128;
                },
                None => {
                    cli.eprintln("memory read error", &format!("memory at {} is null", err_addr));

                    exit(1);
                }
            }
        },
        None => {
            cli.eprintln("memory read error", "failed to get memory");

            exit(1);
        }
    };

    let main_addr = match env.def(run_content.clone()) {
        Ok(ok) => ok,
        Err(err) => {
            cli.eprintln("runtime error", &err.to_string());

            exit(1);
        }
    };
    
    let mut args: Vec<usize> = Vec::new();

    for i in 0..255 {
        if parser.contains(format!("a{}", i)) {
            args.push(match match parser.value_of(format!("a{}", i)) {
                Ok(ok) => ok,
                Err(err) => {
                    cli.eprintln("argument parse error", &err.to_string());

                    exit(1);
                }
            }.parse::<usize>() {
                Ok(ok) => ok,
                Err(err) => {
                    cli.eprintln("argument parse error", &err.to_string());

                    exit(1);
                }
            });
        }
    }

    if verbose {
        let mut printstring = String::new();
    
        for arg in args.iter() {
            printstring.push_str(&format!("{} ", arg));
        }

        cli.println("args", &printstring);
        
        printstring = String::new();

        for code in run_content.iter() {
            printstring.push_str(&format!("{} ", &code.to_string()));
        }

        cli.println("code", &printstring);
    }

    let ret = match unsafe { env.call(main_addr, args) } {
        Ok(ok) => ok,
        Err(err) => {
            cli.eprintln("runtime error", &err.to_string());

            exit(1);
        }
    };

    match ret {
        Ok(ok) => {
            if verbose {
                cli.println("ret", &ok.to_string());
            }
        
            match env.dealloc(err_addr) {
                Ok(ok) => ok,
                Err(err) => {
                    cli.eprintln("memory deallocation error", &err.to_string());

                    exit(1);
                }
            };

            exit(ok as i32);
        },
        Err(err) => {
            cli.println("exception", &format!("caught {}", err));

            if dump {
                let mut printstring = String::new();

                match env.get_mem().get(err) {
                    Some(some) => {
                        match some {
                            Some(some) => {
                                for elem in some.iter() {
                                    printstring.push(*elem as u8 as char);
                                }
                            },
                            None => {
                                printstring = "null".to_string();
                            }
                        }
                    },
                    None => {
                        cli.eprintln("runtime error", &format!("cannot get memory at {}", err));

                        exit(1);
                    }
                };
                
                cli.println(format!("address {}", err), printstring);
            }

            exit(1);
        }
    };
}
