pub mod env;

pub use env::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_env() {
        let mut env = Env::new();
        
        let block1 = match env.alloc(10) {
            Ok(ok) => ok,
            Err(err) => panic!("{}", err.to_string())
        };

        let block2 = match env.alloc(10) {
            Ok(ok) => ok,
            Err(err) => panic!("{}", err.to_string())
        };
        
        assert_eq!(match env.dealloc(block1) {
            Ok(ok) => ok,
            Err(err) => panic!("{}", err.to_string())
        }, 10);

        assert_eq!(match env.dealloc(block2) {
            Ok(ok) => ok,
            Err(err) => panic!("{}", err.to_string())
        }, 10);

        assert_eq!(*env.get_mem(), vec![None, None]);
        assert_eq!(*env.get_mem_mut(), vec![None, None]);
    }
}
