pub type MemoryError = mtk::Error;

pub struct Env {
    mem: Vec<Option<Vec<i128>>>
}

impl Env {
    pub fn new() -> Env {
        Env {
            mem: Vec::new()
        }
    }

    pub fn alloc(&mut self, size: usize) -> Result<usize, MemoryError> {
        if size <= 0 {
            return Err(MemoryError::from(format!("size should be atleast 1")));
        }

        self.mem.push(Some(vec![0x0; size]));

        Ok(self.mem.len() - 1)
    }

    pub fn dealloc(&mut self, addr: usize) -> Result<usize, MemoryError> {
        match self.mem.get_mut(addr) {
            Some(some) => {
                if *some == None {
                    Err(MemoryError::from(format!("address {} is already deallocated", addr)))
                } else {
                    let size = match some {
                        Some(some) => some.len(),
                        None => 0
                    };

                    *some = None;

                    Ok(size)
                }
            },
            None => Err(MemoryError::from(format!("nothing allocated on address {}", addr)))
        }
    }

    pub fn get_mem(&self) -> &Vec<Option<Vec<i128>>> {
        &self.mem
    }

    pub fn get_mem_mut(&mut self) -> &mut Vec<Option<Vec<i128>>> {
        &mut self.mem
    }
}
