pub const ID_TOKEN: &str = "ID_TOKEN"; // QWERTYUIOPASDFGHJKLZXCVBNMqwertyuopasdfghjklizxcvbnm@.-_
pub const INT_TOKEN: &str = "INT_TOKEN"; // 0123456789

#[derive(Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
pub struct Token {
    t_type: String,
    t_value: String
}

impl Token {
    pub fn new(t_type: &str, t_value: String) -> Token {
        Token { t_type: t_type.to_string(), t_value }
    }

    pub fn clone_type(&self) -> String {
        self.t_type.clone()
    }

    pub fn clone_value(&self) -> String {
        self.t_value.clone()
    }

    pub fn to_string(&self) -> String {
        format!("(<{}>, '{}')", self.t_type, self.t_value)
    }
}
