pub fn split(string: String) -> Result<Vec<String>, mtk::ValueError> {
    if string.contains(" ") {
        let mut res: Vec<String> = Vec::new();

        for e in string.split_whitespace() {
            res.push(e.to_string());
        }

        Ok(res)
    } else {
        Err(mtk::ValueError::with_string(format!("nothing to split in '{}'", string)))
    } 
}
