use super::*;

pub type LexError = mtk::BasicError;

pub struct Lexer {
    source: String,
    l_res: Vec<Token>,
    ch: char,
    pos: usize
}

impl Lexer {
    pub fn new(source: &String) -> Result<Lexer, LexError> {
        Ok(Lexer {
            source: format!("{}\0", source),
            l_res: Vec::new(),
            ch: match source.chars().nth(0) {
                Some(some) => some,
                None => return Err(LexError::with_string(format!("can not get index 0 of source ('{}')", source)))
            },
            pos: 0
        })
    }

    pub fn res(&mut self) -> Result<Vec<Token>, LexError> {
        while self.ch != '\0' {
            if "QWERTYUIOPASDFGHJKLZXCVBNMqwertyuopasdfghjklizxcvbnm@.-_".contains(self.ch) {
                let mut identifier = String::new();

                while "QWERTYUIOPASDFGHJKLZXCVBNMqwertyuopasdfghjklizxcvbnm@.-_".contains(self.ch) {
                    identifier = identifier + self.ch.to_string().as_str();

                    self.next();
                }

                self.l_res.push(Token::new(ID_TOKEN, identifier));
            } else if "0123456789".contains(self.ch) {
                let mut identifier = String::new();

                while "0123456789".contains(self.ch) {
                    identifier = identifier + self.ch.to_string().as_str();

                    self.next();
                }

                self.l_res.push(Token::new(INT_TOKEN, identifier));
            } else if " \n\r\t".contains(self.ch) {
                self.next();
            } else {
                return Err(LexError::with_string(format!("character {} at index {} of '{}' is not unsupported", self.ch, self.pos, self.source)));
            }
        }

        Ok(self.clone_res())
    }

    pub fn next(&mut self) -> () {
        if self.pos < self.source.len() {
            self.pos = self.pos + 1;
            self.ch = match self.source.chars().nth(self.pos) {
                Some(some) => some,
                None => return ()
            };
        } else {
            ()
        }
    }

    pub fn clone_res(&self) -> Vec<Token> {
        self.l_res.clone()
    }
}
