use super::*;

pub type CompilationError = mtk::BasicError;

pub fn compile(lexer: &Lexer) -> Result<Vec<u8>, CompilationError> {
    let mut res: Vec<u8> = Vec::new();
    let lexed = lexer.clone_res();

    for token in lexed {
        if token.clone_type() == ID_TOKEN {
            if token.clone_value() == "jmp_f" {
                res.push(JMP_F);
            } else if token.clone_value() == "jmp_r" {
                res.push(JMP_F);
            } else if token.clone_value() == "jmp_b" {
                res.push(JMP_B);
            } else if token.clone_value() == "mov_n" {
                res.push(MOV_N);
            } else if token.clone_value() == "mov_f" {
                res.push(MOV_R);
            } else if token.clone_value() == "qhalt" {
                res.push(QHALT);
            } else {
                return Err(CompilationError::with_string(format!("unknown identifier '{}'", token.clone_value())));
            }
        } else if token.clone_type() == INT_TOKEN {
            res.push(match token.clone_value().parse::<u8>() {
                Ok(ok) => ok,
                Err(err) => return Err(CompilationError::with_string(format!("could not parse '{}' to single byte: {}", token.clone_value(), err.to_string())))
            });
        } else {
            return Err(CompilationError::with_string(format!("unexpected token {}", token.clone_type())));
        }
    }

    Ok(res)
}
